﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "timer3.h"

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{
	if(TM3IF && TM3IE)
	{
		TM3IF = 0;
		PT1_0 = ~PT1_0;
	}
}

//============================================
// program start
//============================================
void main()
{
	unsigned char mode = 0;
	GIE = 0;
	timer3_init();
	PWM3STALL = 0;	//ICD调试stall（例如单步）时，定时器3单端PWM输出低电平，此配置取决于外围硬件情况，用于在芯片调试暂停时保护外围硬件不会受损
	switch(mode)
	{
		case 0:		//计数器模式
		{		
			PT1EN_0 = 1;	//PT1.0为数字输出口，无上拉
			PT1PU_0 = 0;
			PT1CON = 0;
			PT1_0 = 0;
			
			P3L2OEN = 0;
			P3H2OEN = 0;
			PWM3PO = 0;
			
			T3OUT = 0;		//PT3.5为普通IO口
			PWM3OUT = 0;
			
			timer3_pwm_period(TIMER3_COUNT);	//4ms溢出一次
		}break;
				
		case 1:		//普通PWM模式
		{
			PT5EN_1 = 1;	//PT5.1为PWM3输出口,数字输出口，无上拉
			PT5PU_1 = 0;
			PT5CON_1 = 0;
			
			P3L2OEN = 0;
			P3H2OEN = 0;
			PWM3PO = 1;
			P3H2OEN = 1;
			timer3_dt_enable();
			
			T3OUT = 0;	//PT5.6为普通IO口
			PWM3OUT = 0;
			
			timer3_pwm_period(TIMER3_COUNT);		//250Hz
			timer3_pwm_duty(TIMER3_PWM_DUTY_50);	//50%
		}break;
				
		case 2:		//蜂鸣器模式
		{
			PT3EN_5 = 1;	//PT3.5为蜂鸣器输出口,数字输出口，无上拉
			PT3PU_5 = 0;
			PT3CON_5 = 0;
			
			P3L2OEN = 0;
			P3H2OEN = 0;
			PWM3PO = 0;
			
			T3OUT = 1;	//PT5.6为普通IO口
			PWM3OUT = 0;
			
			T3RATE_0 = 0;
			T3RATE_1 = 0;
			T3RATE_2 = 1;
			T3RATE_3 = 1;		//时钟修改为MCK/16，2MHz
			
			timer3_pwm_period(TIMER3_COUNT);	//4KHz
		}break;
				
		case 3:		//互补PWM模式
		{
			PT5EN_0 = 1;	//PT5.0为PWM3_L输出口,数字输出口，无上拉
			PT5PU_0 = 0;
			PT5CON_0 = 0;
			PT5EN_1 = 1;	//PT5.1为PWM3_H输出口,数字输出口，无上拉
			PT5PU_1 = 0;
			PT5CON_1 = 0;
			
			P3L2OEN = 1;
			P3L2INV = 1;
			P3H2OEN = 1;
			P3H2INV = 0;
			
			timer3_dt_enable();
			timer3_dt_clk();	//MCK/4
			timer3_dt_time(TIMER3_DT_TIME);		//死区时间为250ns
			
			T3RATE_0 = 0;
			T3RATE_1 = 0;
			T3RATE_2 = 0;
			T3RATE_3 = 1;		//时钟修改为MCK，32MHz

			timer3_pwm_period(TIMER3_COUNT);		//128KHz
			timer3_pwm_duty(TIMER3_PWM_DUTY_50);	//50%
		}break;
		
		default : mode = 0;
	}
	timer3_count_clr();
	timer3_enable();
	timer3_int_enable();
	while(1);
}
